function [shift_energy] = lines_shift(bands, bandgap)

index = zeros(1, size(bands, 2));

for k=1:size(bands, 2)
    temp = find(real(bands(:,k)) > bandgap);
    index(k) = temp(1);
end
    
max_index = max(index);
min_index = min(index);
size_shift = size(bands, 1) - (max_index - min_index);

shift_energy = zeros(size_shift, size(bands, 2));

for i=1:size_shift
    for k=1:size(bands, 2)
        shift_energy(i, k) = bands(i+index(k)-min_index, k);
    end
end

end